#include <windows.h>
#define ID_BUTTON 100
#define ID_OPNBTN 101
#define ID_EDIT_C 102
#define ID_EDIT_M 103
#define WM_LOADSC3FILE (WM_APP + 1)
#define WM_WRITESC3FILE (WM_APP + 2)
#define APPTITLE "SC3k City Renamer"
#define EOCDF (dwSize<=(DWORD)(ptmp-fptmp))

LRESULT CALLBACK WndProc(HWND, UINT, WPARAM, LPARAM);

int WINAPI WinMain(HINSTANCE hInst, HINSTANCE hPrevInst, LPSTR lpsCmdLine, int nCmdShow)
{
	char szClassName[] = "sc3rn";
	MSG msg;
	BOOL bRet;
	WNDCLASSEX wc;
	HWND hWnd;
	LPSTR ptmp;
	wc.cbSize = sizeof(WNDCLASSEX);
	wc.style = CS_HREDRAW | CS_VREDRAW;
	wc.lpfnWndProc = WndProc;
	wc.cbClsExtra = 0;
	wc.cbWndExtra = 0;
	wc.hInstance = hInst;
	wc.hIcon = NULL;
	wc.hCursor = LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground = (HBRUSH)(COLOR_BTNFACE+1);
	wc.lpszMenuName = NULL;
	wc.lpszClassName = (LPCSTR)szClassName;
	wc.hIconSm = NULL;
	if (!RegisterClassEx(&wc)) return 0;
	hWnd = CreateWindowEx(WS_EX_ACCEPTFILES, szClassName, APPTITLE, 
		WS_OVERLAPPED | WS_SYSMENU | WS_MINIMIZEBOX | WS_VISIBLE, 
		CW_USEDEFAULT, CW_USEDEFAULT, 256, 100, 
		NULL, NULL, hInst, NULL);
	if (!hWnd) return 0;
	UpdateWindow(hWnd);
	ptmp = lpsCmdLine;
	if (*ptmp == '"') {
		while (*++ptmp) {
			if (*ptmp == '"') {
				*ptmp = '\0';
				SendMessage(hWnd, WM_LOADSC3FILE, 0, (LPARAM)lpsCmdLine + 1);
				break;
			}
		}
	} else if (*++ptmp == ':') {
		ptmp++;
		while (*++ptmp) {
			if (*ptmp == ':') {
				ptmp[-2] = '\0';
				break;
			}
		}
		SendMessage(hWnd, WM_LOADSC3FILE, 0, (LPARAM)lpsCmdLine);
	}
	while ((bRet = GetMessage(&msg, NULL, 0, 0)) != -1) {
		if (!bRet) break;
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
	return (int)msg.wParam;
}

LRESULT CALLBACK WndProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	static char *fData = NULL, fName[MAX_PATH + 60], oName[MAX_PATH], CityName[55], MayorName[55];
	static HWND hOpn, hBtn, hEditC, hEditM;
	static DWORD dwSize;
	static HANDLE hFile;
	switch (msg) {
		case WM_CREATE: {
			hEditC = CreateWindow("EDIT", "", 
				WS_CHILD | WS_VISIBLE | WS_BORDER | ES_AUTOHSCROLL,
				52, 20, 150, 22, hWnd, (HMENU)ID_EDIT_C, NULL, NULL);
			hEditM = CreateWindow("EDIT", "", 
				WS_CHILD | WS_VISIBLE | WS_BORDER | ES_AUTOHSCROLL,
				52, 44, 150, 22, hWnd, (HMENU)ID_EDIT_M, NULL, NULL);
			hOpn = CreateWindow("BUTTON", "J", 
				WS_CHILD | WS_VISIBLE,  204, 20, 44, 22, 
				hWnd, (HMENU)ID_OPNBTN, NULL, NULL);
			hBtn = CreateWindow("BUTTON", "Kp", 
				WS_CHILD | WS_VISIBLE,  204, 44, 44, 22, 
				hWnd, (HMENU)ID_BUTTON, NULL, NULL);
			SendMessage(hEditC, EM_SETLIMITTEXT, (WPARAM)50, 0);
			SendMessage(hEditM, EM_SETLIMITTEXT, (WPARAM)50, 0);
			break;
		}
		case WM_PAINT: {
			HDC hdc;
			PAINTSTRUCT ps;
			int bkm;
			hdc = BeginPaint(hWnd, &ps);
			bkm = SetBkMode(hdc, TRANSPARENT);
			TextOut(hdc, 2, 1, oName, (int)strlen(oName));
			TextOut(hdc, 2, 22, "ss", 6);
			TextOut(hdc, 2, 46, "s", 6);
			SetBkMode(hdc, bkm);
			EndPaint(hWnd, &ps);
			break;
		}
		case WM_COMMAND: {
			switch (LOWORD(wParam)) {
				case ID_OPNBTN: {
					int id;
					char szFile[MAX_PATH];
					OPENFILENAME ofn;
					memset(&ofn, 0, sizeof(OPENFILENAME));
					ofn.lStructSize = sizeof(OPENFILENAME);
					ofn.hwndOwner = hWnd;
					ofn.lpstrFilter = "sc3 file(*.sc3)\0*.sc3\0All files(*.*)\0*.*\0\0";
					ofn.lpstrFile = szFile;
					ofn.nMaxFile = MAX_PATH;
					ofn.Flags = OFN_FILEMUSTEXIST | OFN_HIDEREADONLY;
					ofn.lpstrDefExt = "sc3";
					ofn.lpstrTitle = "J";
					id = GetOpenFileName(&ofn);
					if (id) {
						memcpy(fName, szFile, strlen(szFile) + 1);
						SendMessage(hWnd, WM_LOADSC3FILE, 1, 0);
					}
					break;
				}
				case ID_BUTTON:
					SendMessage(hWnd, WM_WRITESC3FILE, 0, 0);
					break;
				default:
					return (DefWindowProc(hWnd, msg, wParam, lParam));
			}
		}
		case WM_DROPFILES: {
			DragQueryFile((HDROP)wParam, 0, fName, sizeof(fName));
			DragFinish((HDROP)wParam);
		}
		case WM_LOADSC3FILE: {
			char *ptmp, *fptmp;
			if (!wParam) memcpy(fName, (LPSTR)lParam, strlen((LPSTR)lParam) + 1);
			if (!*fName) break;
			hFile = CreateFile(fName, GENERIC_READ, 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
			if (hFile == INVALID_HANDLE_VALUE) {
				MessageBox(hWnd, "R}h܂̓t@CႢ܂", APPTITLE, MB_OK);
				break;
			}
			dwSize = GetFileSize(hFile, NULL);
			ptmp = fptmp = HeapAlloc(GetProcessHeap(), 0, dwSize);
			ReadFile(hFile, fptmp, dwSize, &dwSize, NULL);
			CloseHandle(hFile);
			if (*((DWORD*)ptmp)++ != 0x80c381d7) dwSize = 0;
			while (!EOCDF && *((DWORD*)ptmp) != 0x62f42635) ptmp += 20;
			if (*((DWORD*)ptmp + 2) != 0xe2f42628) dwSize = 0;
			if (EOCDF) {
				MessageBox(hWnd, "t@C̎ނsA܂͖\n", APPTITLE, MB_OK | MB_ICONSTOP);
				HeapFree(GetProcessHeap(), 0, fptmp);
				break;
			}
			ptmp += 12;
			ptmp = fptmp + *(DWORD*)ptmp + 36;
			memcpy(MayorName, ptmp, *ptmp + 4);
			MayorName[*ptmp + 4] = '\0';
			SetWindowText(hEditM, MayorName + 4);
			ptmp += *ptmp + 4;
			memcpy(CityName, ptmp, *ptmp + 4);
			CityName[*ptmp + 4] = '\0';
			SetWindowText(hEditC, CityName + 4);
			memcpy(oName, fName, strlen(fName) + 1);
			HeapFree(GetProcessHeap(), 0, fData);
			fData = fptmp;
			InvalidateRect(hWnd, NULL, TRUE);
			break;
		}
		case WM_WRITESC3FILE: {
			int g, h;
			char *ptmp, *fptmp, *ffptmp, *cfData;
			DWORD *pdw, *fpdw;
			GetWindowText(hEditC, CityName + 4, 51);
			g = strlen(CityName + 4) - *CityName;
			*CityName = strlen(CityName + 4);
			GetWindowText(hEditM, MayorName + 4, 51);
			g += strlen(MayorName + 4) - *MayorName;
			*MayorName = strlen(MayorName + 4);
			if (!g) {
				pdw = (DWORD*)(ptmp = fData);
				while(*pdw++ != 0xe2f42628);
				ptmp = fData + *pdw + 36;
				memcpy(ptmp, MayorName, *MayorName + 4);
				ptmp += *MayorName + 4;
				memcpy(ptmp, CityName, *CityName + 4);
				while(*pdw++ != 0xfa1);
				ptmp = fData + *pdw + 28;
				ptmp += *ptmp + 16;
				memcpy(ptmp, CityName, *CityName + 4);
				ptmp += *CityName + 4;
				memcpy(ptmp, MayorName, *MayorName + 4);
			} else {
				pdw = (DWORD*)(ptmp = cfData = (char*)HeapAlloc(GetProcessHeap(), 0, dwSize + g * 2));
				fpdw = (DWORD*)fData;
				while(*fpdw++ != 0xe2f42628);
				memcpy(ptmp, fData, *fpdw + 36);
				ptmp += *fpdw + 36;
				memcpy(ptmp, MayorName, *MayorName + 4);
				ptmp += *MayorName + 4;
				memcpy(ptmp, CityName, *CityName + 4);
				ptmp += *CityName + 4;
				fptmp = fData + (ptmp - cfData - g);
				while(*fpdw++ != 0xfa1);
				ffptmp = fData + *fpdw + 28;
				ffptmp += *ffptmp + 16;
				memcpy(ptmp, fptmp, ffptmp - fptmp);
				ptmp += ffptmp - fptmp;
				memcpy(ptmp, CityName, *CityName + 4);
				ptmp += *CityName + 4;
				memcpy(ptmp, MayorName, *MayorName + 4);
				ptmp += *MayorName + 4;
				fptmp = fData + (ptmp - cfData - g * 2);
				memcpy(ptmp, fptmp, dwSize + fData - fptmp);
				dwSize += g * 2;
				HeapFree(GetProcessHeap(), 0, fData);
				fpdw = (DWORD*)(fData = cfData);
				while (*fpdw++ != 0xe2f42628);
				fpdw[1] += g;
				fpdw += 5;
				while (fpdw[-1] != 0xfa1) {
					0[fpdw] += g;
					fpdw += 5;
				}
				fpdw[0] += g;
				fpdw[1] += g;
				g *= 2;
				fpdw += 5;
				while (fpdw[-1]) {
					0[fpdw] += g;
					fpdw += 5;
				}
			}
			hFile = CreateFile(oName, GENERIC_WRITE, 0, NULL, OPEN_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
			WriteFile(hFile, fData, dwSize, &dwSize, NULL);
			if (g < 0) {
				SetFilePointer(hFile, g, NULL, FILE_END);
				SetEndOfFile(hFile);
			}
			CloseHandle(hFile);
			if (wParam == WM_DESTROY) DestroyWindow(hWnd);
			break;
		}
		case WM_CLOSE: {
			int id;
			char str[51];
			if (!*oName) DestroyWindow(hWnd);
			id = 0;
			GetWindowText(hEditC, str, 51);
			if (!strcmp(CityName + 4, str)) id++;
			GetWindowText(hEditM, str, 51);
			if (!strcmp(MayorName + 4, str)) id++;
			if (id == 2) DestroyWindow(hWnd);
			wsprintf(fName, "t@C %s ̓e͕ύXĂ܂B\n\nύXۑ܂?", oName);
			id = MessageBox(hWnd, fName, APPTITLE, MB_YESNOCANCEL | MB_ICONWARNING);
			if (id == IDYES) SendMessage(hWnd, WM_WRITESC3FILE, WM_DESTROY, 0);
			else if (id == IDNO) DestroyWindow(hWnd);
			break;
		}
		case WM_DESTROY:
			HeapFree(GetProcessHeap(), 0, fData);
			CloseHandle(hFile);
			PostQuitMessage(0);
			break;
		default:
			return (DefWindowProc(hWnd, msg, wParam, lParam));
	}
	return 0;
}